// Sass configuration
var gulp = require('gulp');
var sass = require('gulp-sass');
var uglify = require('gulp-uglify');
var gutil = require('gulp-util');
var rename = require('gulp-rename');

gulp.task('sass', function() {
    gulp.src('dev/*.scss')
        .pipe(sass())
        .pipe(gulp.dest('assets/'));
});

gulp.task('js', function() {
    gulp.src('dev/*.js')
        .pipe(uglify())
        .on('error', function (err) { gutil.log(gutil.colors.red('[Error]'), err.toString()); })
        .pipe(rename({suffix: '.min'}))
        .pipe(gulp.dest('assets/'));
})

gulp.task('watch-sass', ['sass'], function() {
    gulp.watch('dev/*.scss', ['sass']);
})

gulp.task('watch-js', ['js'], function() {
    gulp.watch('dev/*.js', ['js']);
})

gulp.task('watch', ['watch-sass', 'watch-js']);